function [] = Generate_Matrix_Latex(A)

[m, n] = size(A);

temp = '[c]{';
for i = 1:n
	temp = [temp, 'c'];
end
temp = [temp, '}'];

One = '\begin{tabular}';
Two = temp;
Four = '\end{tabular}';

% open the file with write permission
fid = fopen('A.txt', 'w');
fprintf(fid, '%s \n %s \n', One, Two);

for k = 1:m
	for l = 1:n
		fprintf(fid, '%8.4f %s', A(k, l), '&');
	end
	fprintf(fid, '\b %s', '\\');
	
	if k==m
		fprintf(fid, '\b\b');
	end
	
	fprintf(fid, '\n');
end

fprintf(fid, '%s \n', Four);
fclose(fid);

% view the contents of the file
type A.txt

end